<% Option Explicit %>
<% Response.Buffer = True %>
<%

'Dimension variables
Dim adoCon 			'Database Connection Variable
Dim rsWeeklyPoll 		'Database Recordset Variable
Dim strCon			'Holds the Database driver and the path and name of the database
Dim strAccessDB 		'Holds the Access Database Name
Dim strSQL 			'Database query sring
Dim strPreviousPollQuestion	'Holds the previous Weekly Poll Questions
Dim intPreviousPollQuestionID	'Holds the previous weekly poll questions Id Number
Dim dtmPreviousPollQuestionDate 'Holds the date the previous weekly poll is from
Dim intRecordPositionPageNum 	'Holds the record position of the previous Poll Titles to display
Dim intRecordLoopCounter	'Loop counter for displaying the previous polling questions


'Declare constants
' ------------- Change the following line to the number of previous Poll Question Titles you wish to have displayed on each page -------

Const intRecordsPerPage = 9 	'Change this number to the number of previous Poll Question Titles to be displayed on each page

'----------------------------------------------------------------------------------------------------------------------------------------------


'Read in the previous poll question titles to display from the database
'If there is no previous titles to display from then start at the last question titles in the database
If Request.QueryString("PagePosition") = "" Then
	intRecordPositionPageNum = 1

'Else the page has been displayed before so the previous Poll Question Titles record postion is set to the Record Position number
Else
	intRecordPositionPageNum = CInt(Request.QueryString("PagePosition"))
End If	

%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Previous Weekly Poll's</title>

<!-- The Surf-Net Weekly Poll is written and produced by Bruce Corkhill 2001
     	If you want your own Weekly Poll then goto http://www.surf-net.co.uk -->
     	
</head>
<body bgcolor="#330099" text="#FFFFFF" link="#66CCFF" vlink="#66CCFF" alink="#FF0000">
<div align="center">
  <h2>Previous Weekly Polls</h2>
  <table width="370" border="0" cellspacing="0" cellpadding="1">
    <%
'Initialise the strAccessDB variable with the name of the Access Database
strAccessDB = "weekly_poll"

'Create a connection odject
Set adoCon = Server.CreateObject("ADODB.Connection")
Set rsWeeklyPoll = Server.CreateObject("ADODB.Recordset")
			 
'Open connection to the database driver
strCon="DRIVER={Microsoft Access Driver (*.mdb)};"
		
'Open Connection to database
strCon = strCon & "DBQ=" & Server.MapPath(strAccessDB)

'Initalise the strSQL variable with an SQL statement to query the database
strSQL = "SELECT * FROM tblPolls "
strSQL = strSQL & " ORDER By tblPolls.id_no DESC;"

'Query the database
rsWeeklyPoll.Open strSQL, strCon, 3

'Set the number of previous Poll Question Titles to display on each page by the constant set at the top of the script
rsWeeklyPoll.PageSize = intRecordsPerPage

'Get the previous Weekly Poll Titles record poistion to display from
If NOT rsWeeklyPoll.EOF Then rsWeeklyPoll.AbsolutePage = intRecordPositionPageNum



' loop through the previous poll questions in the database and display HTML hyperlinks to them
For intRecordLoopCounter = 1 to intRecordsPerPage

	'If there are no more previous Poll Question records left to display then exit loop
	If rsWeeklyPoll.EOF Then Exit For

	'Read in the polling questions ID number from the database
	intPreviousPollQuestionID = CInt(rsWeeklyPoll("id_no"))

	'Read in the polling question from the database
	strPreviousPollQuestion = rsWeeklyPoll("Question")
	
	'Read in the date the poll is from
	dtmPreviousPollQuestionDate = rsWeeklyPoll("Date")
	

	'Write the HTML to display links to all the previous Poll Question Titles
	Response.Write vbCrLf & "	 <tr>"
	Response.Write vbCrLf & "         <td width=""250""><a href=""weekly_poll.asp?PollID=" &  intPreviousPollQuestionID  & "&PagePosition=" & intRecordPositionPageNum & """ target=""_self"">" & strPreviousPollQuestion & "</a></td>"	
	Response.Write vbCrLf & "	  <td width=""120"" align=""right"">" & FormatDateTime(dtmPreviousPollQuestionDate, VbLongDate) & "</td>"
	Response.Write vbCrLf & "	 </tr>"
	
	
	'Move to the next record
	rsWeeklyPoll.MoveNext

Next



 %>
  </table>
  <br>
  <!-- Table to display next and previous links for other previous weekly poll questions -->
  <table width="370" border="0" cellspacing="1" cellpadding="1" align="center" height="21">
    <tr align="center"> 
      <td align="left" width="83"> 
        <%
      
'If the previous Poll Question Titles page number is higher than page 1 then display a back link    	
If intRecordPositionPageNum > 1 Then 
	Response.Write "	<a href=""previous_weekly_polls.asp?PagePosition=" &  intRecordPositionPageNum - 1  & """ target=""_self"">&lt;&lt;&nbsp;Prev</a>"   	     	
End If
      
      %>
      </td>
      <td width="201"> 
        <%
       
'If there are more previous Poll Question Titles to display then add a title to the other pages
If intRecordPositionPageNum > 1 or NOT rsWeeklyPoll.EOF Then
	Response.Write "	Previous Weekly Poll's"
End If
       
      %>
      </td>
      <td align="right" width="76"> 
        <%
       
'If it is Not the End of the previous Poll Question Titles entries then display a next link for the next previous Poll Question Titles page      	
If NOT rsWeeklyPoll.EOF then   	
	Response.Write "	<a href=""previous_weekly_polls.asp?PagePosition=" &  intRecordPositionPageNum + 1  & """ target=""_self"">Next&nbsp;&gt;&gt;</a>"	   	
End If 


'Reset Server Objects
Set adoCon = Nothing
rsWeeklyPoll.Close
Set rsWeeklyPoll = Nothing       
       
      %>
      </td>
    </tr>
  </table>
  <br>
  <a href="JavaScript:window.close()">Close Window</a><br>
  <br>
  <a href="http://www.surf-net.co.uk" target="_blank"><img src="surf-net_logo.gif" width="88" height="31" border="0" alt="Surf-net"></a></div>
</body>
</html>